#ifndef LLF_RSA_PRIM_H
#define LLF_RSA_PRIM_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Wed Mar 07 18:11:47 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level 
* functions that supports PKCS#1 v2.1 primitive functions
* which worked with LibTomCrypt.
* 
* \version LLF_RSA_PRIM.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_RSA_PRIM_Encrypt
*
* Inputs:
*  @param UserPubKey_ptr [in] - A pointer to the public key data structure;
*  @param Data_ptr   [in] - A pointer to the data to encrypt;
*  @param DataSize   [in] - The size, in bytes, of the data to encrypt;
*  @param Output_ptr [out] - Pointer to the encrypted data.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PUB_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_BUFFER_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  LLF_RSA_PRIM_Encrypt implements the RSAEP algorithm as defined in
*  PKCS#1 v2.1 6.1.1
*
* \b
* Algorithm:
*  -# Register and initialize prng and hash;
*  -# Build RSA public key using values from UserPubKey_ptr;
*  -# Encrypt data using RSA public key.
***************************************************************/
CE2Error_t LLF_RSA_PRIM_Encrypt(
                        CE2_RSAUserPubKey_t *UserPubKey_ptr,/* in */
                        DxUint8_t           *Data_ptr,		/* in */
                        DxUint16_t           DataSize,		/* in */
                        DxUint8_t           *Output_ptr);	/* out */

/**
****************************************************************
* Function Name: 
*  LLF_RSA_PRIM_Decrypt
*
* Inputs:
*  @param UserPrivKey_ptr [in] - Pointer to the private key data structure;
*  @param Data_ptr   [in] - A pointer to the data to be decrypted;
*  @param DataSize   [in] - The size, in bytes, of the data to decrypt;
*  @param Output_ptr [out] - A pointer to the decrypted data.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_PRIV_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  LLF_RSA_PRIM_Decrypt implements the RSADP algorithm as defined in
*  PKCS#1 v2.1 6.1.2
*
* \b
* Algorithm:
*  -# Register and initialize prng and hash;
*  -# Build RSA private key using values from UserPrivKey_ptr;
*  -# If private key is non CRT, then convert it to CRT mode;
*  -# Decrypt data using RSA private key.
***************************************************************/
CE2Error_t LLF_RSA_PRIM_Decrypt(
                        CE2_RSAUserPrivKey_t *UserPrivKey_ptr, /* in */
                        DxUint8_t     *Data_ptr,	/* in */
                        DxUint16_t     DataSize,	/* in */
                        DxUint8_t     *Output_ptr);	/* out */

#ifdef __cplusplus
}
#endif

#endif /* LLF_RSA_PRIM_H */
